---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")


--- This table maps the areaId (used in the DB for example) to
--- the UiMapId of each zone.
--- The UiMapId identifies a map which can be displayed ingame on the worldmap.
--- Dungeons don't have a UiMapId!
--- https://wow.gamepedia.com/UiMapID/Classic
local areaIdToUiMapId = {
    [0] = 947,
    [1] = 1426,
    [3] = 1418,
    [4] = 1419,
    [8] = 1435,
    [10] = 1431,
    [11] = 1437,
    [12] = 1429,
    [14] = 1411,
    [15] = 1445,
    [16] = 1447,
    [17] = 1413,
    [28] = 1422,
    [33] = 1434,
    [36] = 1416,
    [38] = 1432,
    [40] = 1436,
    [41] = 1430,
    [44] = 1433,
    [45] = 1417,
    [46] = 1428,
    [47] = 1425,
    [51] = 1427,
    [85] = 1420,
    [130] = 1421,
    [139] = 1423,
    [141] = 1438,
    [148] = 1439,
    [215] = 1412,
    [267] = 1424,
    [331] = 1440,
    [357] = 1444,
    [361] = 1448,
    [400] = 1441,
    [405] = 1443,
    [406] = 1442,
    [1941] = 1446,
    [440] = 1446,
    [490] = 1449,
    [493] = 1450,
    [618] = 1452,
    [1377] = 1451,
    [1497] = 1458,
    [1519] = 1453,
    [1537] = 1455,
    [1637] = 1454,
    [1638] = 1456,
    [1657] = 1457,
    [2317] = 1414,
    [2597] = 1459,
    [3277] = 1460,
    [3358] = 1461,
    [3535] = 246,
    [3714] = 246,
    [3790] = 257,
    [3791] = 259,
    [3789] = 260,
    [3713] = 261,
    [3716] = 262,
    [3715] = 264,
    [3717] = 265,
    [3847] = 266,
    [3849] = 268,
    [3848] = 271,
    [3792] = 272,
    [3923] = 330,
    [3836] = 331,
    [3959] = 339,
    [3562] = 347,
    [2839] = 1459,
    [3607] = 1554,
    [3845] = 1555,
    [3430] = 1941,
    [3433] = 1942,
    [3524] = 1943,
    [3483] = 1944,
    [676] = 1945,
    [3905] = 1946,
    [3521] = 1946,
    [3557] = 1947,
    [3520] = 1948,
    [3522] = 1949,
    [3525] = 1950,
    [3518] = 1951,
    [3519] = 1952,
    [3523] = 1953,
    [3842] = 1953,
    [3487] = 1954,
    [3703] = 1955,
    [3820] = 1956,
    [4080] = 1957,
}

-- [areaId] = {"name", alternative areaId (a sub zone), parentId}
local dungeons = {
    [209] = {"Shadowfang Keep", 236, 130},
    [491] = {"Razorfen Kraul", 1717, 17},
    [717] = {"The Stockade", nil, 1519},
    [718] = {"Wailing Caverns", nil, 17},
    [719] = {"Blackfathom Deeps", 2797, 331},
    [721] = {"Gnomeregan", 133, 1},
    [722] = {"Razorfen Downs", 1316, 17},
    [796] = {"Scarlet Monastery", nil, 85},
    [1176] = {"Zul'Farrak", 978, 440},
    [1337] = {"Uldaman", 1517, 3},
    [1477] = {"The Temple of Atal'Hakkar", 1417, 8},
    [1581] = {"The Deadmines", nil, 40},
    [1583] = {"Blackrock Spire", nil, 51},
    [1584] = {"Blackrock Depths", nil, 51},
    [1585] = {"Blackrock Depths", nil, 51},
    [2017] = {"Stratholme", 2279, 139},
    [2057] = {"Scholomance", nil, 28},
    [2100] = {"Maraudon", nil, 405},
    [2366] = {"The Black Morass", nil, 440},
    [2367] = {"Old Hillsbrad Foothills", nil, 440},
    [2437] = {"Ragefire Chasm", nil, 1637},
    [2557] = {"Dire Maul", 2577, 357},
    [3457] = {"Kharazan", nil, 41},
    [3562] = {"Hellfire Ramparts",nil,3483},
    [3606] = {"Hyjal Summit", nil, 440},
    [3713] = {"The Blood Furnace",nil,3483},
    [3714] = {"The Shattered Halls",3535,3483},
    [3715] = {"The Steamvault",nil,3521},
    [3716] = {"The Underbog",nil,3521},
    [3717] = {"The Slave Pens",nil,3521},
    [3789] = {"Shadow Labyrinth",nil,3519},
    [3790] = {"Auchenai Crypts",nil,3519},
    [3791] = {"Sethekk Halls",nil,3519},
    [3792] = {"Mana-Tombs",nil,3519},
    [3847] = {"The Botanica",nil,3523},
    [3848] = {"The Arcatraz",nil,3523},
    [3849] = {"The Mechanar",nil,3523},
}

function ZoneDB:GetDungeons()
    return dungeons
end

-- [areaId] = {{areaId, locationX, locationY}, ...}
local dungeonLocations = {
    [209] = {{130, 45, 68.7}},
    [491] = {{17, 42.3, 89.9}},
    [717] = {{1519, 40.5, 55.9}},
    [718] = {{17, 46, 36.5}},
    [719] = {{331, 14.1, 14.4}},
    [721] = {{1, 24.4, 39.8}},
    [722] = {{17, 50.8, 92.8}},
    [796] = {{85, 83, 34}},
    [1176] = {{440, 38.7, 20.1}},
    [1337] = {{3, 44.4, 12.2}, {3, 65.2, 43.5}},
    [1417] = {{8, 69.4, 56.8}},
    [1477] = {{8, 69.4, 56.8}},
    [1581] = {{40, 42.5, 71.1}},
    [1583] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [1584] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [1585] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [1977] = {{33, 50.6, 17.6}},
    [2017] = {{139, 30.9, 17}},
    [2057] = {{28, 69.8, 73.6}},
    [2100] = {{405, 29.5, 62.5}},
    [2159] = {{15, 52.4, 76.4}},
    [2257] = {{1519, 60.3, 12.5}, {1537, 72.8, 50.3}},
    [2366] = {{440, 57.4, 62.8}},
    [2367] = {{440, 55.6, 53.7}},
    [2437] = {{1637, 51.7, 49.8}},
    [2557] = {{357, 59.2, 45.1}},
    [2597] = {{36, 66.6, 51.3},},
    [2677] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [2717] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [2917] = {{1637, 40.4, 68.3}},
    [2918] = {{1519, 72.7, 54}},
    [3428] = {{1377, 29, 95}},
    [3429] = {{1377, 29, 95}},
    [3456] = {{139, 39.9, 25.8}},
    [3457] = {{41, 46.71, 70.22}},
    [3562] = {{3483, 47.7, 53.6}},
    [3606] = {{440, 57.2, 49.9}},
    [3713] = {{3483, 46.0, 51.8}},
    [3714] = {{3483, 47.7, 52.0}},
    [3715] = {{3521, 50.4, 40.9}},
    [3716] = {{3521, 50.4, 40.9}},
    [3717] = {{3521, 50.4, 40.9}},
    [3789] = {{3519, 39.6, 71.0}},
    [3790] = {{3519, 36.1, 65.6}},
    [3791] = {{3519, 43.2, 65.6}},
    [3792] = {{3519, 39.7, 60.2}},
    [3847] = {{3523, 71.7, 55.0}},
    [3848] = {{3523, 74.4, 57.7}},
    [3849] = {{3523, 70.6, 69.7}},
    [7307] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
}

-- [dungeonZone] = parentZone
local dungeonParentZones = {
    [236] = 209,
    [1717] = 491,
    [2797] = 719,
    [133] = 721,
    [1316] = 722,
    [978] = 1176,
    [1517] = 1337,
    [1417] = 1477,
    [2279] = 2017,
    [2577] = 2557,
}

-- [subZone] = parentZone
local subZoneToParentZone = {
    [2839] = 2597,
    [35] = 33,
    [1116] = 357,
    [702] = 141,
    [1769] = 361,
    [3917] = 3688,
    [3696] = 3522,
    [2300] = 1941,
    [3545] = 3535,
    [3563] = 3535,
    [3845] = 3842,
    -- starting zones
    [9] = 12,
    [132] = 1,
    [154] = 85,
    [188] = 141,
    [220] = 215,
    [363] = 14,
    [3431] = 3430,
    [3526] = 3524,
}

function ZoneDB:GetZoneTables()
    return {
        areaIdToUiMapId,
        dungeons,
        dungeonLocations,
        dungeonParentZones,
        subZoneToParentZone
    }
end

-- Different source of zoneIds
-- These are not in use anymore but are quite helpful when fixing the database
-- https://www.ownedcore.com/forums/world-of-warcraft/world-of-warcraft-emulator-servers/60411-zone-ids.html
ZoneDB.zoneIDs = {
    DUN_MOROGH = 1,
    BADLANDS = 3,
    BLASTED_LANDS = 4,
    SWAMP_OF_SORROWS = 8,
    DUSKWOOD = 10,
    WETLANDS = 11,
    ELWYNN_FOREST = 12,
    DUROTAR = 14,
    DUSTWALLOW_MARSH = 15,
    AZSHARA = 16,
    THE_BARRENS = 17,
    WESTERN_PLAGUELANDS = 28,
    STRANGLETHORN_VALE = 33,
    ALTERAC_MOUNTAINS = 36,
    LOCH_MODAN = 38,
    WESTFALL = 40,
    DEADWIND_PASS = 41,
    REDRIDGE_MOUNTAINS = 44,
    ARATHI_HIGHLANDS = 45,
    BURNING_STEPPES = 46,
    THE_HINTERLANDS = 47,
    SEARING_GORGE = 51,
    TIRISFAL_GLADES = 85,
    SILVERPINE_FOREST = 130,
    EASTERN_PLAGUELANDS = 139,
    TELDRASSIL = 141,
    DARKSHORE = 148,
    SHADOWFANG_KEEP = 209,
    MULGORE = 215,
    HILLSBRAD_FOOTHILLS = 267,
    ASHENVALE = 331,
    FERALAS = 357,
    FELWOOD = 361,
    THOUSAND_NEEDLES = 400,
    DESOLACE = 405,
    STONETALON_MOUNTAINS = 406,
    TANARIS = 440,
    UN_GORO_CRATER = 490,
    RAZORFEN_KRAUL = 491,
    MOONGLADE = 493,
    WINTERSPRING = 618,
    THE_STOCKADE = 717,
    WAILING_CAVERNS = 718,
    BLACKFATHOM_DEEPS = 719,
    GNOMEREGAN = 721,
    RAZORFEN_DOWNS = 722,
    SCARLET_MONASTERY = 796,
    ZUL_FARRAK = 1176,
    ULDAMAN = 1337,
    SILITHUS = 1377,
    THE_TEMPLE_OF_ATAL_HAKKAR = 1477,
    UNDERCITY = 1497,
    STORMWIND_CITY = 1519,
    IRONFORGE = 1537,
    THE_DEADMINES = 1581,
    LOWER_BLACKROCK_SPIRE = 1583,
    BLACKROCK_DEPTHS = 1585,
    ORGRIMMAR = 1637,
    THUNDER_BLUFF = 1638,
    DARNASSUS = 1657,
    ZUL_GURUB = 1977,
    STRATHOLME = 2017,
    SCHOLOMANCE = 2057,
    MARAUDON = 2100,
    ONYXIAS_LAIR = 2159,
    DEEPRUN_TRAM = 2257,
    SOUTH_SEAS = 2317,
    THE_BLACK_MORASS = 2366,
    OLD_HILLSBRAD_FOOTHILLS = 2367,
    RAGEFIRE_CHASM = 2437,
    DIRE_MAUL = 2557,
    ALTERAC_VALLEY = 2597,
    BLACKWING_LAIR = 2677,
    MOLTEN_CORE = 2717,
    HALL_OF_LEGENDS = 2917,
    CHAMPIONS_HALL = 2918,
    WARSONG_GULCH = 3277,
    ARATHI_BASIN = 3358,
    AHN_QIRAJ = 3428,
    RUINS_OF_AHN_QIRAJ = 3429,
    NAXXRAMAS = 3456,
    EVERSONG_WOODS = 3430,
    GHOSTLANDS = 3433,
    HELLFIRE_PENINSULA = 3483,
    SILVERMOON_CITY = 3487,
    NAGRAND = 3518,
    TEROKKAR_FOREST = 3519,
    SHADOWMOON_VALLEY = 3520,
    ZANGARMARSH = 3521,
    BLADES_EDGE_MOUNTAINS = 3522,
    NETHERSTORM = 3523,
    AZUREMYST_ISLE = 3524,
    BLOODMYST_ISLE = 3525,
    THE_EXODAR = 3557,
    HELLFIRE_RAMPARTS = 3562,
    HYJAL_SUMMIT = 3606,
    SHATTRATH_CITY = 3703,
    THE_BLOOD_FURNACE = 3713,
    THE_SHATTERED_HALLS = 3714,
    THE_STEAMVAULT = 3715,
    THE_UNDERBOG = 3716,
    THE_SLAVE_PENS = 3717,
    THE_BOTANICA = 3847,
    THE_ARCATRAZ = 3848,
    THE_MECHANAR = 3849,
    SHADOW_LABYRINTH = 3789,
    AUCHENAI_CRYPTS = 3790,
    SETHEKK_HALLS = 3791,
    MANA_TOMBS = 3792,
    SUNWELL_PLATEAU = 4075,
    ISLE_OF_QUEL_DANAS = 4080,
    UPPER_BLACKROCK_SPIRE = 7307,
}
